
// This program is based off of work done by Xander.  Visit his website at http://mightor.wordpress.com/
// Read the Dexter Industries GPS sensor for positional data.  For more on the Dexter Industries GPS Sensor
// vist http://www.dexterindustries.com
// This code is an example of reading the GPS sensor for positional data.
//
// This program datalogs a journey, and saves the coordinates in KML style format for display on google earth.
// It first generates a header.
// Then it adds lat/long data into the file.
// When the program is stopped with the red button, the footer is inserted.
// The file can be saved to the computer.  Use notepad (or equivalent) to "Save As" *.kml
// You should be able to pull the file up and see on Google Earth.

// Note that the default filename in this program is "Path.txt".  You can
// rename it anything you like, as long as it's *.txt.

// Give a file name.
// Will have to rename this as a .kml file after downloading to desktop.
const string sFileName = "Path.txt";  // Our destination KML File

#define SCALE 1000000.0

// file handle used for updating the KML file

TFileHandle hFileHandle;
string KMLfilename;

// Create a uniquely named KML file. Up to 9 versions of the KML file are recorded
// starting with Path1.txt through Path9.txt
// If no unique filename can be created we exit with an error message

void createKMLFile() {

    int i = 1;
    string filename = "";
    TFileIOResult nIoResult;

  // NOTE ON FILESIZE:  Note that the header that's inserted by default is about 800 bytes.
  // NOTE ON FILESIZE:  Every data point added is about 30 bytes in size.
    int nFileSize = 5000;

    hFileHandle = 0;
    while(i < 100) {
        StringFormat(filename, "Path%d.txt", i);
        OpenWrite(hFileHandle, nIoResult, filename, nFileSize);
        if(nIoResult  == ioRsltSuccess) {
            // we have a unique filename
            KMLfilename = filename;
            break;
        }
        i++;
    }

    if(i == 10) {
        nxtDisplayCenteredTextLine(4, "No files free");
        PlaySound(soundLowBuzz);
        wait10Msec(200);
        StopAllTasks();
    }
}

void writeKMLHeader(){
  // This is going to write the header into the memory.

  TFileIOResult nIoResult;

  createKMLFile();

  // Now begin the painful task of writing out the entire header of the KML file
  // There's got to be a better way to do this dude!
  // YAY!
  WriteText(hFileHandle, nIoResult, "<?xml version=\'1.0\'");
  WriteText(hFileHandle, nIoResult, " encoding= \'UTF-8\'");
  WriteText(hFileHandle, nIoResult, "?>");
  WriteText(hFileHandle, nIoResult, "\r\n");

  WriteText(hFileHandle, nIoResult, "<kml xmlns=");
  WriteText(hFileHandle, nIoResult, "\'http://www.opengis");
  WriteText(hFileHandle, nIoResult, ".net/kml/2.2\'");
  WriteText(hFileHandle, nIoResult, ">");
  WriteText(hFileHandle, nIoResult, "\r\n");
  WriteText(hFileHandle, nIoResult, "  <Document>\r\n");
  WriteText(hFileHandle, nIoResult, "    ");
  WriteText(hFileHandle, nIoResult, "<name>Paths</name>");
  WriteText(hFileHandle, nIoResult, "\r\n");

  WriteText(hFileHandle, nIoResult, "    <description>");
  WriteText(hFileHandle, nIoResult, "LEGO Street View");
  WriteText(hFileHandle, nIoResult, "</description>\r\n");
  WriteText(hFileHandle, nIoResult, "    <Style id=\'yel");
  WriteText(hFileHandle, nIoResult, "lowLineGreenPoly\'>");
  WriteText(hFileHandle, nIoResult, "\r\n");

  WriteText(hFileHandle, nIoResult, "      <LineStyle>");
  WriteText(hFileHandle, nIoResult, "\r\n");
  WriteText(hFileHandle, nIoResult, "        <color>7f0");
  WriteText(hFileHandle, nIoResult, "0ffff</color>");
  WriteText(hFileHandle, nIoResult, "\r\n");

  WriteText(hFileHandle, nIoResult, "        <width>4</");
  WriteText(hFileHandle, nIoResult, "width>\r\n");
  WriteText(hFileHandle, nIoResult, "      </LineStyle>");
  WriteText(hFileHandle, nIoResult, "\r\n");

  WriteText(hFileHandle, nIoResult, "      <PolyStyle>");
  WriteText(hFileHandle, nIoResult, "\r\n");
  WriteText(hFileHandle, nIoResult, "        <color>7f0");
  WriteText(hFileHandle, nIoResult, "0ff00</color>");
  WriteText(hFileHandle, nIoResult, "\r\n");

  WriteText(hFileHandle, nIoResult, "      </PolyStyle>");
  WriteText(hFileHandle, nIoResult, "\r\n");
  WriteText(hFileHandle, nIoResult, "    </Style>");
  WriteText(hFileHandle, nIoResult, "\r\n");
}

//////////////////////////////////////////////////////////////////
// Write a placemark entry into the KML file
// Parameters: latitude and longitude
// pictureIndex is the index assigned to the current image filename
//    <Placemark>
//      <name>LSVC Snapshot 1</name>
//     <description>
//        <![CDATA[
//<img src="images/IMG_2315.JPG" width=640 height=480>
//        ]]>
//      </description>
//      <Point>
//        <coordinates>-97.805145, 30.112194, 0</coordinates>
//      </Point>
//    </Placemark>
//
//////////////////////////////////////////////////////////////////
void writeKMLPlacemark(long latitude, long longitude, int pictureIndex) {

    string pis;
    string slat;
    string slon ;
    TFileIOResult nIoResult;
    float flon, flat;

    flon = (float)longitude / SCALE;
    flat = (float)latitude / SCALE;

    StringFormat(pis, "%d", pictureIndex);

	WriteText(hFileHandle, nIoResult, "<Placemark>");
	WriteText(hFileHandle, nIoResult, "\r\n");
	WriteText(hFileHandle, nIoResult, "<name>LSVC ");
	WriteText(hFileHandle, nIoResult, "Snapshot ");
	WriteText(hFileHandle, nIoResult, pis);
	WriteText(hFileHandle, nIoResult, "</name>");
	WriteText(hFileHandle, nIoResult, "\r\n");

	WriteText(hFileHandle, nIoResult, "<description>");
	WriteText(hFileHandle, nIoResult, "<![CDATA[<img src=\'");
	WriteText(hFileHandle, nIoResult, PATH_PREFIX);
	WriteText(hFileHandle, nIoResult, FILENAME_PREFIX);
	WriteText(hFileHandle, nIoResult, pis);
	WriteText(hFileHandle, nIoResult, FILENAME_EXTENSION);
	WriteText(hFileHandle, nIoResult, "\' width=640 ");
	WriteText(hFileHandle, nIoResult, "height=480> ]]>");
	WriteText(hFileHandle, nIoResult, "</description>\r\n");

	WriteText(hFileHandle, nIoResult, "<Point>\r\n");
	WriteText(hFileHandle, nIoResult, "<coordinates>");

    slat = flat;
	slon = flon;

    WriteText(hFileHandle, nIoResult, "\r\n");
    WriteText(hFileHandle, nIoResult, slon);
    WriteText(hFileHandle, nIoResult, ",");
    WriteText(hFileHandle, nIoResult, slat);
    WriteText(hFileHandle, nIoResult, ",");
    WriteText(hFileHandle, nIoResult, "0");
	WriteText(hFileHandle, nIoResult, "</coordinates>\r\n");
	WriteText(hFileHandle, nIoResult, "</Point>\r\n");
	WriteText(hFileHandle, nIoResult, "</Placemark>\r\n");

}

//////////////////////////////////////////////////////////////////
// Write the path string to the KML file
// Parameters:
// lastCoord - last coordinate entry in the array
//
// Iterate over the coordinates stored in the array and write each
// one out to the KML file as part of a pathstring
//
//    <Placemark>
//		<name>LSVC Path</name>
//		<description>LSVC Path</description>
//		<styleUrl>#yellowLineGreenPoly</styleUrl>
//	    <LineString>
//			<extrude>10</extrude>
//			<tessellate>10</tessellate>
//	 		<altitudeMode>clampToGround</altitudeMode>
//	        <coordinates>
//	        -97.805145, 30.112194, 0
//	        -97.809975, 30.106791, 0
//	        -97.945213, 29.864613, 0
//	        </coordinates>
//	    </LineString>
//	</Placemark>
//
//////////////////////////////////////////////////////////////////
void writeKMLPathstring(int lastCoord){
    TFileIOResult nIoResult;
    int i;
 	float flat, flon;
 	string slat, slon;

	// Write the pre-amble to the coordinates
	///////////////////////////////// 123456878901234567890
	WriteText(hFileHandle, nIoResult, "<Placemark>\r\n");
	WriteText(hFileHandle, nIoResult, "<name>LSVC Path");
	WriteText(hFileHandle, nIoResult, "</name>\r\n");
	WriteText(hFileHandle, nIoResult, "<description>");
	WriteText(hFileHandle, nIoResult, "LSVC Path");
	WriteText(hFileHandle, nIoResult, "</description>\r\n");
	WriteText(hFileHandle, nIoResult, "<styleUrl>#yellow");
	WriteText(hFileHandle, nIoResult, "LineGreenPoly");
	WriteText(hFileHandle, nIoResult, "</style");
	WriteText(hFileHandle, nIoResult, "Url>\r\n");
	WriteText(hFileHandle, nIoResult, "<LineString>\r\n");
	WriteText(hFileHandle, nIoResult, "<extrude>10");
	WriteText(hFileHandle, nIoResult, "</extrude>");
	WriteText(hFileHandle, nIoResult, "\r\n<tessellate>10");
	WriteText(hFileHandle, nIoResult, "</tessellate>\r\n");
	WriteText(hFileHandle, nIoResult, "<altitudeMode>");
	WriteText(hFileHandle, nIoResult, "clampToGround");
	WriteText(hFileHandle, nIoResult, "</altitudeMode>\r\n");
	WriteText(hFileHandle, nIoResult, "<coordinates>\r\n");

	for(i=0; i < lastCoord; i++) {
	    flon = (float)coordinates[i].longitude;
	    flon = flon / SCALE;
	    flat = (float)coordinates[i].latitude;
	    flat = flat / SCALE;

	    slat = flat;
	    slon = flon;

		WriteText(hFileHandle, nIoResult, "\r\n");
		WriteText(hFileHandle, nIoResult, slon);
		WriteText(hFileHandle, nIoResult, ",");
		WriteText(hFileHandle, nIoResult, slat);
		WriteText(hFileHandle, nIoResult, ",");
		WriteText(hFileHandle, nIoResult, "0");
    }

    WriteText(hFileHandle, nIoResult, "</coordinates>\r\n");
	WriteText(hFileHandle, nIoResult, "</LineString>\r\n");
	WriteText(hFileHandle, nIoResult, "</Placemark>\r\n");

}

void writeKMLfooter(){
  // Finishes off the file.
  // Closes the file.

    TFileIOResult nIoResult;

	WriteText(hFileHandle, nIoResult, "\r\n");
	WriteText(hFileHandle, nIoResult, "  </Document>");
	WriteText(hFileHandle, nIoResult, "\r\n");
	WriteText(hFileHandle, nIoResult, "</kml>");
	WriteText(hFileHandle, nIoResult, "\r\n");

	Close(hFileHandle, nIoResult);
}
