
void closeAllConns() {
  writeDebugStreamLine("closeAllCons");
  ubyte close_cmd[] = {'A','T','+','N','C','L','O','S','E','A','L','L',0x0D};
  debugnxtWriteRawHS(close_cmd[0], sizeof(close_cmd));       // Send the command, byte by byte.
  Receive(false);
}

// Starts up a TCP server gets the CID.
int startTCP(long port) {
  int index = 0;
  int cid = 0;
  ubyte listen_cmd[] = {'A','T','+','n','s','t','c','p','=','2','0'};
  index = appendToBuff(buffer, index, listen_cmd, sizeof(listen_cmd));
  index = appendToBuff(buffer, index, newline, sizeof(newline));
  debugnxtWriteRawHS(buffer[0], index);
  while (nxtGetAvailHSBytes() == 0) wait1Msec(5);
  while (nxtGetAvailHSBytes() > 0) {
    nxtReadRawHS(BytesRead[0], 1);
    writeDebugStream("%c", BytesRead[0]);
    if(BytesRead[0] < 58 && BytesRead > 47){  // So if it's a number . . .
      cid = BytesRead[0]-48;  // Works for connections 0 through 9.
    }
    wait1Msec(2);
  }

  return cid;
}

// Open the KML Path file and delivery it line-at-a-time over the
// open connection
void sendKMLFile(int cid, int fileindex) {
    int i;
    ubyte b[1];
    ubyte linebuff[20];
	int index = 0;
    TFileIOResult nIoResult;
    TFileHandle hFileHandle;
    int nFileSize;
    string filename = "";

    ubyte hdr[] = {27, 'S', 49};
    ubyte tmp[1];
    ubyte trailer[] = {27, 'E'};

    StringFormat(filename, "Path%d.txt", fileindex-48);

    writeDebugStream("Sending file ");
    writeDebugStreamLine(filename);
    nxtScrollText(filename);

	OpenRead(hFileHandle, nIoResult, filename, nFileSize);

	if(nIoResult != ioRsltSuccess) {
	    nxtScrollText("File error");
	    PlaySound(soundLowBuzz);
	    wait10Msec(100);
	    return;
	}

	for(i=0; i < sizeof(hdr); i++) {
	    nxtWriteRawHS(hdr[i], 1);
	    while(nxtHS_Status == HS_SENDING) wait1Msec(5);
    	nxtReadRawHS(tmp[0], 1);
    }

    for(i=0; i < nFileSize; i++) {
        ReadByte(hFileHandle, nIoResult, b[0]);
	    nxtWriteRawHS(b[0], 1);
	    while(nxtHS_Status == HS_SENDING) wait1Msec(5);
    	nxtReadRawHS(tmp[0], 1);
    }

    for(i=0; i < sizeof(trailer); i++) {
	    nxtWriteRawHS(trailer[i], 1);
	    while(nxtHS_Status == HS_SENDING) wait1Msec(5);
    	nxtReadRawHS(tmp[0], 1);

    }

	Close(hFileHandle, nIoResult);

	nxtScrollText("Done");
	writeDebugStreamLine("Send Done");
}

void parseTCP(int cid_connection)
{
  writeDebugStreamLine("Parse TCP");

  ubyte BytesRead[20];
  ubyte currByte[] = {0};
  ubyte prevByte[] = {0};
  ubyte conn[] = {0};
  int tone = 0;
  int lineNum = 6;
  int colNum = 0;
  string tmpString;

  int index = 0;
  while(true)
  {
      alive();
      if (nxtGetAvailHSBytes() > 0)
        {
        nxtReadRawHS(currByte[0], 1);
        if ((prevByte[0] == 27) && (currByte[0] == 'S')) {
          index = 0;

          writeDebugStreamLine("Got ESC-S");

          memset(rxbuffer, 0, sizeof(rxbuffer));
          wait1Msec(1);
          nxtReadRawHS(conn[0], 1);

          writeDebugStreamLine("Conn: %d", conn[0]);

          while (true) {
            while (nxtGetAvailHSBytes() == 0) EndTimeSlice();
            nxtReadRawHS(currByte[0], 1);
            writeDebugStreamLine("currByte[0]=%d", currByte[0]);

	          if ((prevByte[0] == 27) && (currByte[0] == 'E')) {
	            rxbuffer[index--] = 0;
	            rxbuffer[index--] = 0;
	            break;
	          }
	          prevByte[0] = currByte[0];
	          rxbuffer[index++] = currByte[0];
	      }
          for (int i = 0; i < ((index / 19) + 1); i++) {
              memset(BytesRead[0], 0, 20);
              memcpy(BytesRead[0], rxbuffer[i*19], 19);
              StringFromChars(tmpString, BytesRead);
              tone = (int)BytesRead[0];
              tone = tone*10;
              PlayTone(tone, 10);
                while(bSoundActive) EndTimeSlice();
              writeDebugStream(tmpString);
     }
sendKMLFile(1, BytesRead[0]);
        }
        prevByte[0] = currByte[0];
        }
       wait1Msec(1);
 }
}

void echo_tcp(int cid){
  writeDebugStream("TCP Server Started.");
  writeDebugStreamLine("Listening.");
  parseTCP(cid);
}
